---

## **Hacktoria CTF: Echoes of Retaliation Walkthrough**

Stuck on the "Echoes of Retaliation" contract in Hacktoria? This walkthrough will guide you through each step to find the hidden flag.

---

### **Step 1: Initial IP Investigation**

The first piece of information you're given is the IP address: **188.214.181.38**.

To begin, use an IP geolocation service to determine its approximate location. A reliable option is [whatismyipaddress.com](https://whatismyipaddress.com/ip/188.214.181.38). Inputting the IP address into this site will reveal that the location is in the **Yazd Region**. This is your starting point for the investigation.

---

### **Step 2: Unveiling the Hidden Image**

You'll encounter a file named **ExecutionPosition.md**. While it appears to be a Markdown file, a closer look at its contents (specifically, the very beginning of the file) reveals a tell-tale sign that it's actually a **PNG image file**.

The trick here is to simply change the file extension from .md to .png. Once you do this, open the newly renamed file, and you'll be presented with a picture of a specific location within Iran. This image is crucial for the next step.

---

### **Step 3: Geographic Pinpointing with Google Street View**

Now that you have an image of the location, your task is to identify it more precisely. Since you know the general area (Yazd Region), utilize **Google Street View**.

Start by exploring areas around Yazd. Your goal is to find a visual match between the image you uncovered and a real-world location in Google Street View. After some searching, you will eventually pinpoint the exact location in **Hamane**. The coordinates for this location are: **31.8501791, 53.8824913**.

---

### **Step 4: Decoding with What3Words**

With the precise coordinates in hand, the final step involves using **What3Words (W3W)**. What3Words is a proprietary geocoding system that encodes a geographic location into three unique dictionary words.

Navigate to the What3Words website or use their application, and input the coordinates: **31.8501791, 53.8824913**. This will translate the coordinates into their unique three-word address.

The resulting three words are: **continuation.partakes.devolved**.

---

### **Final Answer**

The flag for the "Echoes of Retaliation" CTF is:

continuation.partakes.devolved

Hopefully, this walkthrough helped you successfully complete the challenge\!